using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;

namespace PI.ZB.N1200.ELearning.WinForms.SchoolYear
{
    public partial class UCSchoolYearList : PI.FM.N000.Base.WinForms.Controls.UCBOList<BL.BO.SchoolYear, UCSchoolYearDetails, BL.BO.SchoolYear.Search>
    {
        PI.FM.N000.Base.WinForms.Controls.ProgressForm _progressForm = null;

        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        public UCSchoolYearList()
        {
            InitializeComponent();
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        internal PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }

                return _blVariableRepository;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();


            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent | Gemini.Core.WinForms.Controls.Type.ControlActionType.Delete | Gemini.Core.WinForms.Controls.Type.ControlActionType.Save | Gemini.Core.WinForms.Controls.Type.ControlActionType.New | Gemini.Core.WinForms.Controls.Type.ControlActionType.Custom;
            DataManager.InitColumns(new string[] { "Name", "IsActive", "IsClosed" });//Przetumaczone
            DataManager.ColumnCaptions = new string[] { Gemini.Dictionary.Text.Grid.Name.Value, BL.Dictionary.Text.Grid.SchoolYear.IsActive.Value, BL.Dictionary.Text.Grid.SchoolYear.IsClosed.Value };
        }

        protected override IList<BL.BO.SchoolYear> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            return BLZSBELearning.SchoolYear.Restore();
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.SchoolYear> Args)
        {
            if (Args.Object != null)
            {
                DetailsView.Save();
                DataManager.RefreshCurrent();
            }
        }

        protected override BL.BO.SchoolYear OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            FNewSchoolYear _dialogNew = Gemini.Core.WinForms.Base.Form.Create<FNewSchoolYear>(Plugin, Environment);

            _dialogNew.Initialize(Plugin, Environment);

            if (_dialogNew.ShowDialog() == DialogResult.OK)
            {
                if (_dialogNew.NewSchoolYear != null)
                {
                    foreach (BL.BO.SchoolYear _loopSchoolYear in DataManager.GetObjectCollection())
                    {
                        _loopSchoolYear.IsActive = false;
                    }

                    return _dialogNew.NewSchoolYear;
                }
            }
            return null;
        }

        protected override BL.BO.SchoolYear DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return BLZSBELearning.SchoolYear.Restore(BO);
        }

        protected override void DoCreateToolbarActions()
        {
            if ((DataManager.Current != null) && (DataManager.Current.IsActive == false) && (DataManager.Current.IsClosed == false))
            {
                ControlActionContainer.Add(Gemini.Core.WinForms.Base.ControlActionContainer.GROUP_DATA,
                    new ControlActionDescription(
                        "ArchiwizacjaRokuSzkolnego",
                        new ControlActionKey(Gemini.Core.WinForms.Controls.Type.ControlActionType.Custom, 52),
                        null,
                        Gemini.Core.WinForms.Controls.Type.ControlActionVisibilityType.MenuVisible | Gemini.Core.WinForms.Controls.Type.ControlActionVisibilityType.ToolBarVisible,
                        PI.ZB.N1200.ELearning.WinForms.Resources.Document_Protected,
                        ArchiveSchoolYear
                    )
                );
            }
            base.DoCreateToolbarActions();
        }

        internal void ArchiveSchoolYear(object sender, EventArgs e)
        {
            if ((DataManager.Current != null) && (DataManager.Current.IsActive == false) && (DataManager.Current.IsClosed == false))
            {

                FCloseSchoolYear _dialog = Gemini.Core.WinForms.Base.Form.Create<FCloseSchoolYear>(this.Plugin, Environment);
                _dialog.Initialize(DataManager.Current, Plugin, Environment);

                if (DialogResult.OK == _dialog.ShowDialog())
                {
                    if (_progressForm == null)
                    {
                        _progressForm = new PI.FM.N000.Base.WinForms.Controls.ProgressForm(String.Format(BL.Dictionary.Text.SchoolYear.DoClose.Value, DataManager.Current.Name));
                        _progressForm.DoProcessing = DoArchiveSchoolYear;
                    }
                    _progressForm.ShowDialog();
                }
            }
        }

        private Gemini.Core.BL.Base.MethodResult DoArchiveSchoolYear()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            List<BL.BO.Student> _listStudent = BLZSBELearning.Student.Restore(DataManager.Current);
            List<BL.BO.Class> _listClass = BLZSBELearning.Class.Restore(DataManager.Current);

            if (_listStudent.Count > 0)
            {
                _progressForm.Initialize(_listStudent.Count + _listClass.Count);

                foreach (BL.BO.Student _loopStudent in _listStudent)
                {
                    if (_loopStudent.UserID != null)
                    {
                        PI.FM.N001.Account.BL.BO.User _user = BLZSBELearning.RBL.Account.User.RestoreByID(_loopStudent.UserID);

                        if (_user != null)
                        {
                            BLZSBELearning.APIEduFarma.SyncStudentDelete(_loopStudent);

                            _methodResult.SetSuccess = BLZSBELearning.BLELearning.Statistic.Course.Remove(_user);
                            _methodResult.Add(BLZSBELearning.RBL.Account.User.Remove(_user, BLZSBELearning.ClientID));
                        }
                    }

                    _progressForm.PerformStep();
                    Application.DoEvents();
                }

                foreach (BL.BO.Class _loopClass in _listClass)
                {
                    BLZSBELearning.APIEduFarma.SyncClassDelete(_loopClass);
                    _progressForm.PerformStep();
                    Application.DoEvents();
                }
            }


            if (_methodResult.Success)
            {
                DataManager.Current.IsClosed = true;
                BLZSBELearning.SchoolYear.Save(DataManager.Current);
                DataManager.RefreshCurrent();
            }


            this.CreateToolbarActions();
            Environment.MainWindow.UpdateToolbarMenu(this);

            return _methodResult;
        }
    }
}
